/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.ArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import net.minecraft.class_2540;

public class EnumArrayValue<E extends Enum<E>>
extends ConfigValue<E[]>
implements ArrayValue {
    private boolean fixedSize;

    public EnumArrayValue(ValueData<E[]> value) {
        super(value);
    }

    @Override
    public boolean isFixedSize() {
        return this.fixedSize;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeEnumArray(this.getId(), (Enum[])this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        Class<?> type = this.getValueType().getComponentType();
        this.set(format.readEnumArray(this.getId(), type));
    }

    @Override
    protected void readFieldData(Field field) {
        this.fixedSize = field.getAnnotation(Configurable.FixedSize.class) != null;
    }

    public static final class Adapter<E extends Enum<E>>
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new EnumArrayValue((ValueData<E[]>)ValueData.of(name, (Enum[])value, context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, class_2540 buffer) {
            Enum[] values = (Enum[])value.get();
            buffer.writeInt(values.length);
            for (Enum e : values) {
                buffer.method_10817(e);
            }
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, class_2540 buffer) {
            int count = buffer.readInt();
            Class<?> type = value.getValueType().getComponentType();
            Enum[] enumArray = (Enum[])Array.newInstance(type, count);
            for (int i = 0; i < count; ++i) {
                enumArray[i] = buffer.method_10818(type);
            }
            return enumArray;
        }
    }
}

